<?php
/*
 * Template Name: Portfolio Page
 */
get_header();
?>

<section>
  <div class="inner-pages">
    <div class="page-title col-md-12">
      <div class="container theme-container">
        <div class="row">
          <div class="col-md-6 col-sm-6 page-title-captions">
            <h4><?php the_title(); ?></h4>
          </div>
          <div class="col-md-6 col-sm-6 breadcrumbs">
            <ul>
              <?php if (function_exists('bizzbeepro_custom_breadcrumbs')) bizzbeepro_custom_breadcrumbs(); ?>
            </ul>
          </div>
        </div>
      </div>
    </div>
    <div class="section-row featured-section col-md-12 col-sm-12  col-xs-12">
      <div class="container theme-container">
        <div class="portfolio-column col-md-12">
      <?php
	  	$portfolio_column=get_theme_mod('portfolio_column')?get_theme_mod('portfolio_column'):3;
		if($portfolio_column == 3){
			$bizzbeepro_size='bizzbeepro-portfolio-3column-size'; $bizzbeepro_class='col-md-4';}
		else{
			$bizzbeepro_size='bizzbeepro-portfolio-4column-size';$bizzbeepro_class='col-md-3';}
        $bizzbeepro_args = array(
            'post_type' => 'portfolio',
            'post_status' => 'publish',
            'order' => 'DESC',
            'orderby' => 'post_date',
            'posts_per_page'=> 8,
            'meta_query' => array(
                array(
                    'key' => '_thumbnail_id',
                    'compare' => 'EXISTS'
                ),
            )
        );
        $bizzbeepro_query = new WP_Query($bizzbeepro_args);
        if ($bizzbeepro_query->have_posts()) : while ($bizzbeepro_query->have_posts()) : $bizzbeepro_query->the_post();
        ?>

          <div class="<?php echo $bizzbeepro_class; ?> col-sm-6">
            <div class=" portfolio-box">
              <div class="hover-content">
                <h4 class="portfolio-title"><span><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></span></h4>
                <div class="border-title"><span><!----></span></div>
              </div>
               <?php the_post_thumbnail( $bizzbeepro_size, array( 'alt' => get_the_title(), 'class' => 'img-responsive') ); ?>
              <div class="info-overlay"></div>
            </div>
          </div>
		<?php endwhile;
		endif;
		 ?>
        </div>
      </div>
    </div>
  </div>
</section>

<!--Footer start-->
<?php get_footer(); ?>
<!--Footer end-->