<?php
echo "<h1>🔍 WordPress Diagnostic Report</h1>";
echo "<hr>";

// PHP Version
echo "<h3>✅ PHP Version:</h3>";
echo phpversion();
echo "<hr>";

// Check important WP files
$wp_files = ['index.php', 'wp-config.php', 'wp-load.php', '.htaccess'];
echo "<h3>🗂 Required Files:</h3><ul>";
foreach ($wp_files as $file) {
    if (file_exists($file)) {
        echo "<li style='color: green;'>✔ $file found</li>";
    } else {
        echo "<li style='color: red;'>❌ $file missing</li>";
    }
}
echo "</ul><hr>";

// Show .htaccess contents
echo "<h3>🛠 .htaccess content:</h3>";
if (file_exists('.htaccess')) {
    echo "<pre style='background:#f0f0f0;padding:10px;'>" . htmlentities(file_get_contents('.htaccess')) . "</pre>";
} else {
    echo "<p style='color: red;'>.htaccess not found</p>";
}
echo "<hr>";

// Check error_log existence
echo "<h3>📄 Error Log:</h3>";
$logFiles = ['error_log', 'wp-content/debug.log'];
$foundLog = false;
foreach ($logFiles as $log) {
    if (file_exists($log)) {
        echo "<p style='color: green;'>✔ Log found: $log</p>";
        echo "<pre style='background:#f0f0f0;padding:10px;max-height:300px;overflow:auto;'>" . htmlentities(file_get_contents($log)) . "</pre>";
        $foundLog = true;
    }
}
if (!$foundLog) {
    echo "<p style='color: gray;'>No error logs found.</p>";
}
echo "<hr>";

// Check if debug mode is enabled
echo "<h3>🧪 WP_DEBUG Mode:</h3>";
$wp_config = file_get_contents("wp-config.php");
if (strpos($wp_config, "define('WP_DEBUG', true)") !== false) {
    echo "<p style='color: green;'>✔ WP_DEBUG is enabled</p>";
} elseif (strpos($wp_config, "define('WP_DEBUG', false)") !== false) {
    echo "<p style='color: orange;'>⚠ WP_DEBUG is disabled</p>";
} else {
    echo "<p style='color: gray;'>WP_DEBUG status unknown</p>";
}

echo "<hr><p style='font-size:13px;color:gray;'>Diagnose tool by ChatGPT | Safe version without direct DB load</p>";
?>
