<?php
add_action( 'widgets_init', 'bizzbeepro_widget' );

function bizzbeepro_widget() {
    register_widget( 'bizzbeepro_info_widget' );
}

class bizzbeepro_info_widget extends WP_Widget {

    public function __construct() {
      $widget_ops = array( 
        'class_name' => 'bizzbeepro_info',
        'description' => __('A widget that displays the title, contact information and socia links. ', 'bizzbeepro'),
        'width' => 300,
        'height' => 350,
        'id_base' => 'bizzbeepro-info-widget'
      );
      parent::__construct( 'bizzbeepro_info', __('Get In Touch', 'bizzbeepro'), $widget_ops );
    }
   
    function widget( $bizzbeepro_args, $bizzbeepro_instance ) {
        
	extract( $bizzbeepro_args );
        //Our variables from the widget settings.
        $bizzbeepro_title = apply_filters('widget_title', $bizzbeepro_instance['title'] );

        $bizzbeepro_email = $bizzbeepro_instance['email'];
        $bizzbeepro_phone = $bizzbeepro_instance['phone'];
        $bizzbeepro_fax = $bizzbeepro_instance['fax'];
        $bizzbeepro_website = $bizzbeepro_instance['website'];
		
        $bizzbeepro_facebook = $bizzbeepro_instance['facebook'];
        $bizzbeepro_twitter = $bizzbeepro_instance['twitter'];
        $bizzbeepro_youtube= $bizzbeepro_instance['youtube'];
        $bizzbeepro_rss = $bizzbeepro_instance['rss'];
        echo $before_widget;

        //Display widget
?>

<div class="contributor">
    <h4 class="widget-title"><?php if(!empty($bizzbeepro_instance['title'])) echo $bizzbeepro_instance['title']; else _e("Get In Touch","bizzbeepro"); ?></h4>
    <div class="contact-widget">
		<?php if(!empty($bizzbeepro_instance['phone'])) { ?>
       	 <p><span><?php _e('Phone','bizzbeepro');?>:</span> <?php echo $bizzbeepro_instance['phone']; ?></p>
        <?php } ?>
        <?php if(!empty($bizzbeepro_instance['fax'])) { ?>
      	  <p><span><?php _e('Fax','bizzbeepro');?>:</span> <?php echo $bizzbeepro_instance['fax']; ?></p>
        <?php } ?>
        <?php if(!empty($bizzbeepro_instance['email'])) { ?>
      	  <p><span><?php _e('Email','bizzbeepro');?>:</span> <a href="mailto:<?php echo $bizzbeepro_instance['email']; ?>"><?php echo $bizzbeepro_instance['email']; ?></a></p>
        <?php } ?>
        <?php if(!empty($bizzbeepro_instance['website'])) { ?>
      	  <p><span><?php _e('Website','bizzbeepro');?>:</span> <a href="<?php echo $bizzbeepro_instance['website']; ?>"><?php echo $bizzbeepro_instance['website']; ?></a></p>
        <?php } ?>
    </div>
    <div class="social-icon">      
        <ul> 
			<?php if(!empty($bizzbeepro_instance['facebook'])) { ?>
           	 <li><a target="_blank" class="facebook" href="<?php echo esc_url($bizzbeepro_instance['facebook']); ?>"><i class="fa fa-facebook"></i></a></li>
            <?php } ?>
            <?php if(!empty($bizzbeepro_instance['twitter'])) { ?>
          	  <li><a target="_blank" class="twitter" href="<?php echo esc_url($bizzbeepro_instance['twitter']); ?>"><i class="fa fa-twitter"></i></a></li>
            <?php } ?>
            <?php if(!empty($bizzbeepro_instance['youtube'])) { ?>
           	 <li><a target="_blank" class="youtube" href="<?php echo esc_url($bizzbeepro_instance['youtube']); ?>"><i class="fa fa-youtube"></i></a></li>
            <?php } ?>
            <?php if(!empty($bizzbeepro_instance['rss'])) { ?>
           	 <li><a target="_blank" class="rss" href="<?php echo esc_url($bizzbeepro_instance['rss']); ?>"><i class="fa fa-rss"></i></a></li>
            <?php } ?>
        </ul>
    </div>        
</div>
<?php        
        echo $after_widget;
    }

    //Update the widget
   
    function update( $new_instance, $old_instance ) {
        $bizzbeepro_instance = $old_instance;

        //Strip tags from title and name to remove HTML
        $bizzbeepro_instance['title'] = strip_tags( $new_instance['title'] );
        $bizzbeepro_instance['phone'] = strip_tags( $new_instance['phone'] );
        $bizzbeepro_instance['fax'] = strip_tags( $new_instance['fax'] );
        $bizzbeepro_instance['website'] = strip_tags( $new_instance['website'] );		
        $bizzbeepro_instance['email'] = strip_tags( $new_instance['email'] );		
		
        $bizzbeepro_instance['facebook'] = strip_tags( $new_instance['facebook'] );
        $bizzbeepro_instance['twitter'] = strip_tags( $new_instance['twitter'] );
		$bizzbeepro_instance['youtube'] = strip_tags( $new_instance['youtube'] );
		$bizzbeepro_instance['rss'] = strip_tags( $new_instance['rss'] );

        return $bizzbeepro_instance;
    }

   
    function form( $bizzbeepro_instance ) {
?>
<p>
  <label for="<?php echo $this->get_field_id( 'title' ); ?>">
    <?php _e('Widget Title:', 'bizzbeepro'); ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php if(!empty($bizzbeepro_instance['title'])) { echo $bizzbeepro_instance['title']; } ?>" class="widefat" type="text" />
</p>
<p>
  <label for="<?php echo $this->get_field_id( 'phone' ); ?>">
    <?php _e('Phone:', 'bizzbeepro'); ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'phone' ); ?>" name="<?php echo $this->get_field_name( 'phone' ); ?>" value="<?php if(!empty($bizzbeepro_instance['phone'])) { echo $bizzbeepro_instance['phone']; } ?>" class="widefat" type="text" />
</p>
<p>
  <label for="<?php echo $this->get_field_id( 'fax' ); ?>">
    <?php _e('Country:', 'bizzbeepro'); ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'fax' ); ?>" name="<?php echo $this->get_field_name( 'fax' ); ?>" value="<?php if(!empty($bizzbeepro_instance['fax'])) { echo $bizzbeepro_instance['fax']; } ?>" class="widefat" type="text" />
</p>
<p>
  <label for="<?php echo $this->get_field_id( 'email' ); ?>">
    <?php _e('Email Address:', 'bizzbeepro'); ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'email' ); ?>" name="<?php echo $this->get_field_name( 'email' ); ?>" value="<?php if(!empty($bizzbeepro_instance['email'])) { echo $bizzbeepro_instance['email']; } ?>" class="widefat" type="text" />
</p>
<p>
  <label for="<?php echo $this->get_field_id( 'website' ); ?>">
    <?php _e('Website:', 'bizzbeepro'); ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'website' ); ?>" name="<?php echo $this->get_field_name( 'website' ); ?>" value="<?php if(!empty($bizzbeepro_instance['website'])) { echo esc_url($bizzbeepro_instance['website']); } ?>" class="widefat" type="text" />
</p>

<p>
  <label for="<?php echo $this->get_field_id( 'facebook' ); ?>">
    <?php _e('Facebook url:', 'bizzbeepro'); ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'facebook' ); ?>" name="<?php echo $this->get_field_name( 'facebook' ); ?>" value="<?php if(!empty($bizzbeepro_instance['facebook'])) { echo esc_url($bizzbeepro_instance['facebook']); } ?>" class="widefat" type="text" />
</p>
<p>
  <label for="<?php echo $this->get_field_id( 'twitter' ); ?>">
    <?php _e('Twitter url:', 'bizzbeepro'); ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'twitter' ); ?>" name="<?php echo $this->get_field_name( 'twitter' ); ?>" value="<?php if(!empty($bizzbeepro_instance['twitter'])) { echo esc_url($bizzbeepro_instance['twitter']); } ?>" class="widefat" type="text" />
</p>
<p>
  <label for="<?php echo $this->get_field_id( 'youtube' ); ?>">
    <?php _e('Youtube url:', 'bizzbeepro'); ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'youtube' ); ?>" name="<?php echo $this->get_field_name( 'youtube' ); ?>" value="<?php if(!empty($bizzbeepro_instance['youtube'])) { echo esc_url($bizzbeepro_instance['youtube']); } ?>" class="widefat" type="text" />
</p>
<p>
  <label for="<?php echo $this->get_field_id( 'rss' ); ?>">
    <?php _e('Rss url:', 'bizzbeepro'); ?>
  </label>
  <input id="<?php echo $this->get_field_id( 'rss' ); ?>" name="<?php echo $this->get_field_name( 'rss' ); ?>" value="<?php if(!empty($bizzbeepro_instance['rss'])) { echo esc_url($bizzbeepro_instance['rss']); } ?>" class="widefat" type="text" />
</p>
<?php
    }
}

?>
