<?php
/**
 * The main index template file
 * */
get_header();
?>

<section <?php post_class(); ?>>
  <div class="inner-pages">
    <div class="page-title col-md-12">
      <div class="container theme-container">
        <div class="row">
          <div class="col-md-8 col-sm-6 page-title-captions">
            <h4>
              <?php $blogtitle_check = get_theme_mod( 'bizzbeepro_blogtitle' );
								if( $blogtitle_check != '' ) {  
									echo esc_attr( get_theme_mod('bizzbeepro_blogtitle', '') );
								 } else { 	
									echo _e('Our Blog','bizzbeepro');
							 } ?>
            </h4>
          </div>
        </div>
      </div>
    </div>
    <?php
	$bizzbeepro_fullwidth_blog=get_theme_mod('fullwidth_blog');
	$bizzbeepro_sidebar_position=get_theme_mod('sidebar_position');
	?>
    <div class="section-row col-md-12 col-sm-12 col-xs-12">
      <div class="container theme-container">
        <div class="row">
         <?php if ($bizzbeepro_fullwidth_blog != 1) { if ($bizzbeepro_sidebar_position == 'left') get_sidebar();  }?>        
          <div class="content-blog <?php if ($bizzbeepro_fullwidth_blog == 1) echo 'col-md-12'; else { if ($bizzbeepro_sidebar_position == 'left') echo 'col-md-8 col-md-offset-0'; else echo 'col-md-8';} ?>">
            <?php while (have_posts()) : the_post(); ?>
            <div class="ourblog-box">
              <?php if ( has_post_thumbnail() ) : ?>
              <div class="post-header">
                <div class="image-wrapper">
                  <div class="blur-img"></div>
                  <a href="<?php echo esc_url(get_permalink()); ?>">
                  <?php if ($bizzbeepro_fullwidth_blog == 1){ ?>
                  <?php the_post_thumbnail( 'full', array( 'alt' => get_the_title(), 'class' => 'img-responsive') ); ?>
                  <?php }else{ ?>
                  <?php the_post_thumbnail( 'bizzbeepro-post-image', array( 'alt' => get_the_title(), 'class' => 'img-responsive') ); ?>
                  <?php } ?>
                  </a> </div>
              </div>
              <?php endif; ?>
              <div class="post-detail"> <a href="<?php echo esc_url(get_permalink()); ?>" class="post-title">
                <?php the_title(); ?>
                </a>
                <?php bizzbeepro_entry_meta(); ?>
                <?php the_excerpt(); ?>
              </div>
            </div>
            <?php endwhile; ?>
            <div class="site-pagination col-md-12 col-sm-12">
              <nav role="navigation" class="navigation pagination">
                <div class="nav-links">
                  <?php 	// Previous/next page navigation.
								the_posts_pagination();
							?>
                </div>
              </nav>
            </div>
          </div>
		 <?php if ($bizzbeepro_fullwidth_blog != 1) { if (empty($bizzbeepro_sidebar_position) || $bizzbeepro_sidebar_position == 'right') get_sidebar();  }?>        
        </div>
      </div>
    </div>
  </div>
</section>
<?php get_footer(); ?>
