<?php
/**
*	@package	WPDigiPro License
*	@author 	WPDigiPro Team
*/

/**
*	class DIGIPROLicenseAdapter
*	use for the WPDIGIPRO License Material.
**/
class WPDigiPro_Theme_License_Adapter extends WPDigiPro_Theme_Adapter {

	// public define
	public $menu_slug = ''; public $text_domain = '';

	/** DigiproLicense Linster constructore
	*	@access for relative the family
	*	@two-arguments - first perameter is this product item slug and second perameter is this prodcut text domain.
	*	@call init license constructore
	*	call constructore
	**/
	public function __construct($menu_slug, $text_domain) {
		$this->menu_slug = $menu_slug; $this->text_domain = $text_domain;
		add_action('admin_menu', array( $this, 'WPDigiPro_Adapter_AssetsMenu' ) );
		add_action('admin_enqueue_scripts', array(&$this, 'WPDigiPro_Adapter_Assets'));
		/** License Action **/
		add_action('wp_ajax_wpdigipro_theme_license_action', array(&$this, 'WPDigiPro_Theme_License_Action'));
		add_action('wp_ajax_nopriv_wpdigipro_theme_license_action', array(&$this, 'WPDigiPro_Theme_License_Action'));
		add_action('template_redirect', array(&$this, 'WPDigiPro_Listen_Listener'));
		add_action('admin_init', array(&$this, 'WPDigiPro_Check_License'));
	}

	public function WPDigiPro_Listen_Listener(){
		if(isset($_REQUEST['wpdigipro-action'])&&$_REQUEST['wpdigipro-action']=='client-deactivation'&&isset($_REQUEST['license-key'])){
			$args=array('key'=>(isset($_REQUEST['license-key'])?$_REQUEST['license-key']:''),'status'=>(isset($_REQUEST['current-status'])?$_REQUEST['current-status']:''),'message'=>(isset($_REQUEST['message'])?$_REQUEST['message']:''),'scheme'=>(isset($_REQUEST['scheme'])?$_REQUEST['scheme']:''),'license_status'=>(isset($_REQUEST['license-status'])?$_REQUEST['license-status']:''),'validity_status'=>true);
			$wpdigipro_license_material_string=$this->WPDigiPro_License_Material_Close($args);
			update_option($this->plugin_settings_option.'-plugin-secure-license-material',$wpdigipro_license_material_string); 
			echo json_encode(array('success'=>true)); exit;
		}
	}

	/** DigiproLicense assessts all other scripting register.
	*	@access for relative the family
	*	@no arguments - only register other scripts and style sheet
	*	@html data direct display
	*	call for the Licensing action input form.
	**/
	public function WPDigiPro_Adapter_Assets() {
		wp_register_script('wpdigipro-theme-license-js', get_template_directory_uri().'/licenses/js/wpdigipro-license.js', array());
	}

	/** DigiproLicense assessts all other scripting
	*	@access for relative the family
	*	@no arguments - only enqueue other scripts and style sheet
	*	@html data direct display
	*	call for the Licensing action input form.
	**/
	public function WPDigiPro_Adapter_Enqueue() {
		wp_enqueue_script('wpdigipro-theme-license-js');
	}

	public function WPDigiPro_Adapter_AssetsMenu() {
		global $menu;
		if($this->menu_slug!='') :
			$wpdigiproPage = add_submenu_page($this->menu_slug, __("Theme License"), __("Theme License"), 'manage_options', $this->menu_slug.'-license', array($this, "WPDigiPro_Adapter_AssetsLicenseForm"));
		else :
			$wpdigiproPage = add_menu_page(__("Theme License"), __("Theme License"), 'manage_options', $this->text_domain.'-license', array($this, "WPDigiPro_Adapter_AssetsLicenseForm"));
		endif;
		add_action("admin_print_styles-{$wpdigiproPage}", array(&$this, 'WPDigiPro_Adapter_Enqueue'));
	}

	/** License input form
	*	@access for relative the family
	*	@no arguments - only license input form view
	*	@html data direct display
	*	call for the Licensing action input form.
	**/
	public function WPDigiPro_Adapter_AssetsLicenseForm() {
		$datas=$this->WPDigiPro_Theme_Get_Code();
		if(isset($datas->licenseStatus)&&($datas->licenseStatus=='active')) : $license_action = true; else : $license_action = false; endif; ?>
		<style>.wpdigipro-theme-licenses-form {border: 1px solid #e0e0e0; border-radius: 3px; margin: 0 auto; margin-top: 15px; padding: 20px; width: 50%; } .wpdigipro-theme-licenses-form input.wpdigipro-license-key { width: 100%; }</style>
		<form name="wpdigipro-theme-licenses-form" class="wpdigipro-theme-licenses-form" id="wpdigipro-theme-licenses-form" method="post" data-action="<?php echo (($license_action)?'deactive':'active'); ?>">
			<div class="title-border wpdigipro-gird-md-12" style="display:inline-block;">
				<div class="wpdigipro-gird-md-12">
					<div class="form-group wpdigipro-gird-md-5">
						<?php $license_key='';if(isset($datas->key)&&$datas->key!=''): $license_key = substr($datas->key, 0, 2).'******************'.substr($datas->key, -2); endif; ?>
						<input class="regular-text" placeholder="Enter your license key here.." <?php if($license_action): echo 'readonly'; endif; ?> type="text" class="wpdigipro-license-key" id="wpdigipro-license-key" name="wpdigipro-license-key" value="<?php echo $license_key; ?>" >
					</div>	
					<div class="wpdigipro-gird-md-3" style="margin-top:10px;">
						<button type="submit" name="license-action" value="Deactivate" class="button-primary"><?php (($license_action)? _e('Deactive', $this->text_domain): _e('Active', $this->text_domain)); ?></button>
					</div>
				</div>

				<div class="wpdigirpo-license-message wpdigipro-gird-md-12">
					<?php $digiproMessages = (isset($datas->message)?$this->WPDigiPro_Theme_License_Set_Message($datas->message):''); ?>
					<?php if(!empty($digiproMessages)) : ?>
					<?php foreach($digiproMessages as $message) : ?>
						<p class="<?php if($datas->validityStatus==false): echo 'wpdigipro-error'; endif; ?>"><?php echo $message; ?></p>
					<?php endforeach; endif; ?>
				</div>
			</div>
		</form><?php
	}

	/** License form action
	*	@access for relative the family
	*	@no arguments - ajax action
	*	@return json result
	*	call for the License action.
	**/
	public function WPDigiPro_Theme_License_Action() {
		if(isset($_POST['license_action'])&&($_POST['license_action']!='')) :
			if($_POST['license_action']=='active') {
				$wpdigipro_license_request_args = array(
					'action'	=> 'wpdigipro-activate',
					'key'		=> $_POST['license_key'],
				);
			} else if($_POST['license_action']=='deactive'){
				$data=$this->WPDigiPro_Theme_Get_Code();
				$wpdigipro_license_request_args = array(
					'action'	=> 'wpdigipro-deactive',
					'key'		=> (isset($data->key)?$data->key:''),
				);
			}

			$wpdigipro_response_data = $this->WPDigiPro_Theme_API_Action($wpdigipro_license_request_args); 
			$wpdigipro_return_response = array(); $wpdigipro_option_name='wpdigipro-'.WPDIGIPROTHEME_DIRECTORY_NAME.'-theme-secure-license-material';
			if($wpdigipro_response_data) :
				if(isset($wpdigipro_response_data->status) && ($wpdigipro_response_data->status=='success')) :
					$wpdigipro_return_response=$args=array('key'=>$_POST['license_key'],'status'=>$wpdigipro_response_data->status,'message'=>$wpdigipro_response_data->message,'scheme'=>$wpdigipro_response_data->scheme,'licenseStatus'=>$wpdigipro_response_data->licenseStatus,'validityStatus'=>$wpdigipro_response_data->validityStatus);
					$materialString=$this->WPDigiPro_Theme_License_Material_Close($args);
					update_option($wpdigipro_option_name,$materialString);
				else :
					$wpdigipro_return_response=$args=array('key'=>$data->key,'status'=>$wpdigipro_response_data->status,'message'=>$wpdigipro_response_data->message,'scheme'=>$wpdigipro_response_data->scheme,'licenseStatus'=>$wpdigipro_response_data->licenseStatus,'validityStatus'=>$wpdigipro_response_data->validityStatus);
					$materialString='';
					update_option($wpdigipro_option_name,$materialString);
				endif;
			endif;
			echo json_encode($wpdigipro_return_response); exit;
		endif;
	}

	/** License check action
	*	@access for relative the family
	*	@no arguments - ajax action
	*	@return json result
	*	call for the License Active action call remote server.
	**/
	public function WPDigiPro_Check_License() {
		$datas=$this->WPDigiPro_Theme_Get_Code();
		if(($this->WPDigiPro_Theme_Schedule())&&(!empty($datas))&&(isset($datas->key))&&($datas->key!='')) :
			$wpdigipro_license_request_args = array('action'=>'wpdigipro-check','key'=>$datas->key);
			$wpdigipro_response_data = $this->WPDigiPro_Theme_API_Action($wpdigipro_license_request_args);
			if($wpdigipro_response_data) :
				$args=array('key'=>$datas->key,'status'=>$wpdigipro_response_data->status,'message'=>$wpdigipro_response_data->message,'scheme'=>$wpdigipro_response_data->scheme,'licenseStatus'=>$wpdigipro_response_data->licenseStatus,'validityStatus'=>$wpdigipro_response_data->validityStatus);
				$materialString=$this->WPDigiPro_Theme_License_Material_Close($args);
				$wpdigipro_option_name='wpdigipro-'.WPDIGIPROTHEME_DIRECTORY_NAME.'-theme-secure-license-material';
				update_option($wpdigipro_option_name,$materialString);
			endif;
		endif;return true;
	}

	/** License message settings
	*	@access for relative the family
	*	@one arguments - string of message
	*	@return array of messages
	**/
	public function WPDigiPro_Theme_License_Set_Message($messageString) {
		$messages = array(); if($messageString!='') { $messages = explode('|', $messageString); } return $messages;
	}
}
?>