<?php
/*
 * bizzbeepro Enqueue css and js files
*/
function bizzbeepro_enqueue() {
  wp_enqueue_style('bizzbeepro-bootstrap', get_template_directory_uri() . '/css/bootstrap.css', array(), '04302015');
  wp_enqueue_style('bizzbeepro-font-awesome', get_template_directory_uri() . '/css/font-awesome.css', array(), '04302015');
  wp_enqueue_style('bizzbeepro-theme', get_template_directory_uri() . '/css/theme.css', array());
  wp_enqueue_style('bizzbeepro-style', get_stylesheet_uri());

  wp_enqueue_script('bizzbeepro-bootstrapjs', get_template_directory_uri() . '/js/bootstrap.js', array('jquery'));
  wp_enqueue_script('bizzbeepro-lucid', get_template_directory_uri() . '/js/lucid.js', array('jquery'));
  wp_enqueue_script('bizzbeepro-defaultjs', get_template_directory_uri() . '/js/default.js', array('jquery'));
  
	$bizzbeepro_font = get_theme_mod( 'bizzbeepro_font' ); 
	if(!empty($bizzbeepro_font)) {
		if($bizzbeepro_font == 'electrolize')
			wp_enqueue_style('font-electrolize','//fonts.googleapis.com/css?family=Electrolize',array());
		elseif($bizzbeepro_font == 'lato')
			wp_enqueue_style('font-lato','//fonts.googleapis.com/css?family=Lato',array());
		elseif($bizzbeepro_font == 'ubuntu')
			wp_enqueue_style('font-ubuntu','//fonts.googleapis.com/css?family=Ubuntu',array());
		elseif($bizzbeepro_font == 'prociono')
			wp_enqueue_style('font-prociono','//fonts.googleapis.com/css?family=Prociono',array());
		elseif($bizzbeepro_font == 'roboto')
			wp_enqueue_style('font-roboto','//fonts.googleapis.com/css?family=Roboto',array());
	 }


  if (is_page_template('page-templates/front-page.php')) {
	wp_enqueue_script('bizzbeepro-homepagejs', get_template_directory_uri() . '/js/homepage.js', array('jquery'));  
    wp_enqueue_style('bizzbeepro-owl-curousel', get_template_directory_uri() . '/css/owl.carousel.css', array(), '04302015');
    wp_enqueue_script('bizzbeepro-owl-curousel-js', get_template_directory_uri() . '/js/owl.carousel.min.js', array('jquery'));
  }
  if (is_singular())
    wp_enqueue_script("comment-reply");
}
add_action('wp_enqueue_scripts', 'bizzbeepro_enqueue');
