<?php
/*
 * Template Name: Our Team Page
 */
get_header();
?>

<section>
  <div class="inner-pages">
    <div class="page-title col-md-12">
      <div class="container theme-container">
        <div class="row">
          <div class="col-md-6 col-sm-6 page-title-captions">
            <h4>
              <?php the_title(); ?>
            </h4>
          </div>
          <div class="col-md-6 col-sm-6 breadcrumbs">
            <ul>
              <?php if (function_exists('bizzbeepro_custom_breadcrumbs')) bizzbeepro_custom_breadcrumbs(); ?>
            </ul>
          </div>
        </div>
      </div>
    </div>
    <div class="section-row featured-section col-md-12 col-sm-12  col-xs-12">
      <div class="container theme-container">
        <div class="col-md-12 work-column">
          <div class="row">
            <?php
				$bizzbeepro_args = array(
					'post_type' => 'ourteam',
					'post_status' => 'publish',
					'order' => 'DESC',
					'orderby' => 'post_date',
					'post_per_page'=> -1,
					'meta_query' => array(
						array(
							'key' => '_thumbnail_id',
							'compare' => 'EXISTS'
						),
					)
				);
				$bizzbeepro_query = new WP_Query($bizzbeepro_args);
				if ($bizzbeepro_query->have_posts()) : while ($bizzbeepro_query->have_posts()) : $bizzbeepro_query->the_post();
					$bizzbeepro_designation=get_post_meta(get_the_ID(),'designation',true)?get_post_meta(get_the_ID(),'designation',true):'';
					$bizzbeepro_fb=get_post_meta(get_the_ID(),'fb',true)?get_post_meta(get_the_ID(),'fb',true):'';
					$bizzbeepro_tw=get_post_meta(get_the_ID(),'tw',true)?get_post_meta(get_the_ID(),'tw',true):'';
					$bizzbeepro_email=get_post_meta(get_the_ID(),'email',true)?get_post_meta(get_the_ID(),'email',true):'';
					$bizzbeepro_content=get_the_content();
				?>
            <div class="col-md-3 col-sm-6 col-xs-12 work-box">
              <div class="team-img">
                <?php the_post_thumbnail( 'bizzbeepro-team-size', array( 'alt' => get_the_title(), 'class' => 'img-responsive') ); ?>
                <div class="over-backface"></div>
              </div>
              <div class="team-info">
                <h3>
                                  <a href="<?php echo get_permalink(get_the_ID()); ?>"><?php the_title(); ?></a>
                </h3>
                <p><span><?php echo $bizzbeepro_designation; ?></span></p>
                <?php echo wp_trim_words($bizzbeepro_content,0,10); ?>
                <?php if(!empty($bizzbeepro_fb) || !empty($bizzbeepro_tw) || !empty($bizzbeepro_email)){ ?>
                <ul>
                  <?php if(!empty($bizzbeepro_fb)) : ?>
                  <li><a href="<?php echo $bizzbeepro_fb; ?>"><i class="fa fa-facebook"></i></a></li>
                  <?php endif; ?>
                  <?php if(!empty($bizzbeepro_tw)) : ?>
                  <li><a href="<?php echo $bizzbeepro_tw; ?>"><i class="fa fa-twitter"></i></a></li>
                  <?php endif; ?>
                  <?php if(!empty($bizzbeepro_email)) : ?>
                  <li><a href="mailto:<?php echo $bizzbeepro_email; ?>"><i class="fa fa-envelope-o"></i></a></li>
                  <?php endif; ?>
                </ul>
                <?php } ?>
              </div>
            </div>
            <?php endwhile;
				endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!--Footer start-->
<?php get_footer(); ?>
<!--Footer end-->